#!/bin/bash
DEBS="rsync sshpass"

usage(){
	echo "Usage: $0 -s <SourceIPAddress> -p <rootPassword>"
	exit 1
}

while getopts :s:p: o; do
	case ${o} in
		s)
			SRC=${OPTARG}
			;;
		p)
			export SSHPASS=${OPTARG}
			;;
		*)
			echo "ERROR: invalid argument"
			usage
			;;
	esac
done
if [ -z "${SRC}" ]; then
	echo "ERROR: source IP address not set"
	usage
fi

if [ -z "${SRC}" ]; then
	echo "ERROR: root password not set"
	usage
# Check connectivity
fi
echo | nc -w3 ${SRC} 22 &> /dev/null
if [ $? -ne 0 ]; then
	echo "ERROR: cannot reach ${SRC}"
	exit 1
fi
# Checking password
sshpass -e ssh -o StrictHostKeyChecking=no root@${SRC} ls / &> /dev/null
if [ $? -ne 0 ]; then
	echo "ERROR: cannot login to ${SRC}"
	exit 1
fi

# Importing labs
echo "---------------------------------------------------------------------------"
echo " IMPORTING LABS"
echo "---------------------------------------------------------------------------"
sshpass -e rsync -av -e ssh root@${SRC}:/opt/unetlab/labs /opt/unetlab 
if [ $? -ne 0 ]; then
	echo "ERROR: failed to import labs"
	exit 1
fi

# Force SRC database backup
echo "---------------------------------------------------------------------------"
echo " SRC DB BACKUP GENERATE"
echo "---------------------------------------------------------------------------" 
sshpass -e ssh -o StrictHostKeyChecking=no root@${SRC} "/usr/bin/mysqldump --password=pnetlab --add-drop-database --skip-comments  --databases pnetlab_db guacdb > /tmp/remotedb.sql"
if [ $? -ne 0 ]; then
	echo "ERROR: failed to create remote db backup"
	exit 1
fi
# Importing database backup file
echo "---------------------------------------------------------------------------"
echo "  SRC DB BACKUP IMPORT"
echo "---------------------------------------------------------------------------" 
sshpass -e rsync -av -e ssh root@${SRC}:/tmp/remotedb.sql /opt/unetlab/backup_database/remote
if [ $? -ne 0 ]; then
	echo "ERROR: failed to import remote db backup file"
	exit 1
fi
# Restore database backup file
echo "---------------------------------------------------------------------------"
echo " SRC DB BACKUP RESTORE"
echo "---------------------------------------------------------------------------" 
cat /opt/unetlab/backup_database/remote/remotedb.sql | /usr/bin/mysql --password=pnetlab
if [ $? -ne 0 ]; then
	echo "ERROR: failed to restore database"
	exit 1
fi
# check version 
if [ -e /opt/unetlab/version ] ; then \
	version=$(cat /opt/unetlab/version)
mysql -uroot -ppnetlab -D pnetlab_db -e "replace control (control_name, control_value) values ('ctrl_version','$version')" 2>/dev/null
fi
echo "---------------------------------------------------------------------------"
echo " MIGRATION COMPLETED"
echo "---------------------------------------------------------------------------"