#!/bin/bash


# Fixing setcap
setcap cap_net_admin+ep /usr/bin/tunctl
setcap cap_net_admin+ep /bin/ip
setcap cap_net_admin+ep /sbin/brctl
setcap cap_net_admin+ep /usr/bin/ovs-vsctl
setcap cap_net_admin+ep /opt/unetlab/wrappers/iol_wrapper

# Fixing resolconf
resolvconf -u


#disable filtering
sysctl -w net.ipv4.conf.all.rp_filter=0

# Deleting logs
rm -f /opt/unetlab/data/Logs/* /opt/unetlab/data/Exports/*
#/usr/sbin/apache2ctl graceful

#Disable ipv6
sysctl -w net.ipv6.conf.all.disable_ipv6=1
# Tune pnet for Dot1x
for i in /sys/class/net/pnet*/bridge/group_fwd_mask  ; do echo 8 > $i ; done

#tune for nat

iptables -t nat -A POSTROUTING -s 10.0.137.0/24  -o pnet0 -j MASQUERADE
iptables -P FORWARD ACCEPT

sysctl -w net.bridge.bridge-nf-call-arptables=0
sysctl -w net.bridge.bridge-nf-call-ip6tables=0
sysctl -w net.bridge.bridge-nf-call-iptables=0

# filtering L2
#CLEAR ebtables
ebtables -F INPUT
ebtables -F OUTPUT
ebtables -F FORWARD

#STP
ebtables -A FORWARD -o eth0  --802_3-sap 0x42 -j DROP -p LENGTH
ebtables -A FORWARD -o eth0  -d BGA -j DROP
#Dot1Q
ebtables -A FORWARD -d 1:0:c:cc:cc:cd -o eth0 -j DROP
#DTP
ebtables -A FORWARD -d 1:0:c:cc:cc:cc -o eth0 -j DROP
# Detecting new disk and resize Root Filesystem

# VM env ????
cat /proc/cpuinfo | grep -q hypervisor
if [ $? == 0 ]; then \
	echo Running Virtual Environment...
	echo Check new disks
	disks=$(dmesg | grep 'SCSI disk' | sed -e 's/.*\[//' -e 's/\].*//')
	for disk in $disks ; do \
		pvs | grep -q $disk
		if [ $? != 0 ]; then \
			# New disk found
			echo New disk $disk found
			pvcreate /dev/$disk
			echo -n "Detecting VG...."
			VGS=$(vgs --noheading | awk '{print $1}')
			echo $VGS
			vgextend $VGS /dev/$disk
			echo -n "Detecting ROOT FS..."
			ROOTLV=$(mount | grep ' / ' | awk '{print $1}')
			echo $ROOTLV
			lvextend -l +100%FREE $ROOTLV	
			echo Resizing ROOT FS
			resize2fs $ROOTLV
		fi
	done
fi

# Enable or Disable UKSM
if [[ -e /sys/kernel/mm/uksm/run ]]; then 
    if [[ -e /opt/unetlab/uksm ]]; then
        cat /opt/unetlab/uksm > /sys/kernel/mm/uksm/run
    fi
fi

#Create cpulimit cgroup
cgcreate -g pids:/cpulimit

# Setting /etc/issue
echo "PNETLab (default root password is 'pnet')" > /etc/issue
if [[ -e "/sys/class/net/pnet0" ]]; then
    INTERFACE="pnet0"
    IP="$([[ $(ifconfig ${INTERFACE} 2> /dev/null | grep 'inet') =~ inet\ +([0-9]+.[0-9]+.[0-9]+.[0-9]+) ]] && echo ${BASH_REMATCH[1]})"
    if [[ $? -eq 0 ]]; then
        echo "Use https or http://${IP}/" >> /etc/issue
    else
        echo "No IP address on interface ${INTERFACE}" >> /etc/issue
    fi
elif [[ -e "/sys/class/net/eth0" ]]; then
    INTERFACE="eth0"
    IP="$([[ $(ifconfig ${INTERFACE} 2> /dev/null | grep 'inet') =~ inet\ +([0-9]+.[0-9]+.[0-9]+.[0-9]+) ]] && echo ${BASH_REMATCH[1]})"
    if [[ $? -eq 0 ]]; then
        echo "Use http://${IP}/" >> /etc/issue
    else
        echo "No IP address on interface ${INTERFACE}" >> /etc/issue
    fi
else
    INTERFACE=""
    IP=""
    echo "No suitable interface found" >> /etc/issue

fi

# set mysql TZ to UTC
echo "SET GLOBAL time_zone = '+00:00' ;" | mysql -u root --password=pnetlab
fgrep -e vmx -e svm /proc/cpuinfo 2>&1 > /dev/null
if [[ $? -eq 0 ]]; then
cat >> /etc/issue << EOF

EOF
#Disable numa balancing
sysctl -w kernel.numa_balancing=0
echo "10000" > /sys/module/kvm/parameters/halt_poll_ns
else
cat >> /etc/issue << EOF

WARNING: neither Intel VT-x or AMD-V found

EOF
fi
# set the right templates

fgrep -e vmx -e svm /proc/cpuinfo 2>&1 > /dev/null 
if [[ $? -eq 0 ]]; then
grep -q vmx /proc/cpuinfo && echo -n vmx > /opt/unetlab/platform
grep -q svm /proc/cpuinfo && echo -n svm > /opt/unetlab/platform
echo N > /sys/module/kvm/parameters/report_ignored_msrs
echo Y > /sys/module/kvm/parameters/ignore_msrs
fi
systemd-detect-virt -v > /opt/unetlab/hypervisor
# Work around Bare Bug
sudo systemctl start apache2
sudo systemctl restart apache2
#fix apache if required
grep -q PrivateTmp /lib/systemd/system/apache2.service 
if [[ $? -eq 0 ]]; then 
        sed -i -e '/^PrivateTmp/d' /lib/systemd/system/apache2.service  &> /dev/null
        systemctl daemon-reload
        systemctl restart apache2
fi
